/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ega.egacryptor.configuration;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.openpgp.PGPException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import uk.ac.ebi.ega.egacryptor.cryptography.Cryptography;
import uk.ac.ebi.ega.egacryptor.cryptography.pgp.PGPCryptography;
import uk.ac.ebi.ega.egacryptor.pipeline.CryptographyPipeline;
import uk.ac.ebi.ega.egacryptor.pipeline.DefaultCryptographyPipeline;
import uk.ac.ebi.ega.egacryptor.service.FileDiscoveryService;
import uk.ac.ebi.ega.egacryptor.service.IFileDiscoveryService;
import uk.ac.ebi.ega.egacryptor.service.ITaskExecutorService;
import uk.ac.ebi.ega.egacryptor.service.TaskExecutorService;

@Configuration
public class EgaCryptorConfiguration {
    @Value(value="${pgp.encryption.buffersize:2048}")
    private int bufferSize;

    @Bean
    public CryptographyPipeline initDefaultCryptographyPipeline(Cryptography cryptography) {
        if (this.bufferSize > 0 && (this.bufferSize & this.bufferSize - 1) != 0) {
            throw new RuntimeException("Buffer size for encryption should be power of 2");
        }
        return new DefaultCryptographyPipeline(cryptography, this.bufferSize);
    }

    @Bean
    public ITaskExecutorService initTaskExecutorService(CryptographyPipeline cryptographyPipeline) {
        return new TaskExecutorService(cryptographyPipeline);
    }

    @Bean
    public IFileDiscoveryService initFileDiscoveryService() {
        return new FileDiscoveryService();
    }

    @Bean
    public Cryptography initPGPCryptography(@Value(value="${pgp.public.key}") String publicKeyPath) throws IOException, PGPException {
        ClassPathResource resource = new ClassPathResource(publicKeyPath);
        if (!resource.exists()) {
            throw new RuntimeException("Public key file ".concat(publicKeyPath).concat(" not found"));
        }
        try (InputStream inputStream = resource.getInputStream();){
            PGPCryptography pGPCryptography = new PGPCryptography(inputStream, this.bufferSize);
            return pGPCryptography;
        }
    }
}

