/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ega.egacryptor.cryptography.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.ega.egacryptor.cryptography.Cryptography;
import uk.ac.ebi.ega.egacryptor.cryptography.pgp.PGPUtils;
import uk.ac.ebi.ega.egacryptor.exception.CryptographyException;
import uk.ac.ebi.ega.egacryptor.exception.pgp.PGPCryptographyException;
import uk.ac.ebi.ega.egacryptor.stream.pgp.PGPEncryptedOutputStream;

public class PGPCryptography
implements Cryptography {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPCryptography.class);
    private final PGPPublicKey pgpPublicKey;
    private final int bufferSize;

    public PGPCryptography(InputStream publicKeyringInputStream, int bufferSize) throws IOException, PGPException {
        this.pgpPublicKey = PGPUtils.readPublicKey((InputStream)publicKeyringInputStream);
        this.bufferSize = bufferSize;
        this.installProviderIfNeeded();
    }

    public OutputStream encrypt(OutputStream fileOutputStream) throws CryptographyException {
        try {
            return this.doEncrypt(fileOutputStream);
        }
        catch (IOException | PGPException e) {
            LOGGER.error("Error in encryption - {}", (Object)e.getMessage());
            throw new PGPCryptographyException(e.getMessage(), e);
        }
    }

    public InputStream decrypt(InputStream fileToDecryptInputStream, char[] password) {
        throw new UnsupportedOperationException();
    }

    private OutputStream doEncrypt(OutputStream fileOutputStream) throws IOException, PGPException {
        OutputStream pgpEncryptedDataGeneratorOutputStream = PGPUtils.getEncryptedGenerator((PGPPublicKey)this.pgpPublicKey).open(fileOutputStream, new byte[this.bufferSize]);
        PGPCompressedDataGenerator pgpCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        OutputStream pgpCompressedDataGeneratorOutputStream = pgpCompressedDataGenerator.open(pgpEncryptedDataGeneratorOutputStream);
        PGPLiteralDataGenerator pgpLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream pgpLiteralDataGeneratorOutputStream = pgpLiteralDataGenerator.open(pgpCompressedDataGeneratorOutputStream, 'b', "", new Date(), new byte[this.bufferSize]);
        return new PGPEncryptedOutputStream(pgpLiteralDataGeneratorOutputStream, pgpCompressedDataGenerator, pgpEncryptedDataGeneratorOutputStream);
    }

    private void installProviderIfNeeded() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

