/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ega.egacryptor.cryptography.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.ega.egacryptor.cryptography.pgp.PGPCryptography;

/*
 * Exception performing whole class analysis ignored.
 */
public class PGPUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPCryptography.class);
    private static final int KEY_FLAGS = 27;
    private static final List<Integer> MASTER_KEY_CERTIFICATION_TYPES = Arrays.asList(19, 18, 17, 16);

    public static PGPPublicKey readPublicKey(InputStream inputStream) throws IOException, PGPException {
        LOGGER.trace("Searching for public key in keyring");
        PGPPublicKeyRingCollection pgpPublicKeyRings = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)inputStream), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey publicKey = null;
        Iterator publicKeyRingIterator = pgpPublicKeyRings.getKeyRings();
        while (publicKey == null && publicKeyRingIterator.hasNext()) {
            PGPPublicKeyRing pgpPublicKeyRing = (PGPPublicKeyRing)publicKeyRingIterator.next();
            Iterator publicKeyIterator = pgpPublicKeyRing.getPublicKeys();
            while (publicKey == null && publicKeyIterator.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)publicKeyIterator.next();
                if (!key.isEncryptionKey()) continue;
                publicKey = key;
            }
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("Can't find public key in the key ring.");
        }
        if (!PGPUtils.isForEncryption(publicKey)) {
            throw new IllegalArgumentException("KeyID ".concat(publicKey.getKeyID() + " not flagged for encryption."));
        }
        LOGGER.debug("Public key found for encryption with KeyID {}", (Object)publicKey.getKeyID());
        return publicKey;
    }

    public static PGPEncryptedDataGenerator getEncryptedGenerator(PGPPublicKey pgpPublicKey) {
        PGPEncryptedDataGenerator pgpEncryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(3).setWithIntegrityPacket(true).setSecureRandom(new SecureRandom()).setProvider("BC"));
        pgpEncryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(pgpPublicKey).setProvider("BC"));
        return pgpEncryptedDataGenerator;
    }

    private static boolean isForEncryption(PGPPublicKey key) {
        if (key.getAlgorithm() == 3 || key.getAlgorithm() == 17 || key.getAlgorithm() == 19) {
            return false;
        }
        return PGPUtils.hasKeyFlags((PGPPublicKey)key, (int)12);
    }

    private static boolean hasKeyFlags(PGPPublicKey encKey, int keyUsage) {
        if (encKey.isMasterKey()) {
            Iterator iterator = MASTER_KEY_CERTIFICATION_TYPES.iterator();
            while (iterator.hasNext()) {
                int masterKeyCertType = (Integer)iterator.next();
                Iterator pgpSignatureIterator = encKey.getSignaturesOfType(masterKeyCertType);
                while (pgpSignatureIterator.hasNext()) {
                    PGPSignature pgpSignature = (PGPSignature)pgpSignatureIterator.next();
                    if (!PGPUtils.isNotMatchingUsage((PGPSignature)pgpSignature, (int)keyUsage)) continue;
                    return false;
                }
            }
        } else {
            Iterator signaturesOfType = encKey.getSignaturesOfType(24);
            while (signaturesOfType.hasNext()) {
                PGPSignature pgpSignature = (PGPSignature)signaturesOfType.next();
                if (!PGPUtils.isNotMatchingUsage((PGPSignature)pgpSignature, (int)keyUsage)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isNotMatchingUsage(PGPSignature pgpSignature, int keyUsage) {
        PGPSignatureSubpacketVector pgpSignatureSubpacketVector;
        if (pgpSignature.hasSubpackets() && (pgpSignatureSubpacketVector = pgpSignature.getHashedSubPackets()).hasSubpacket(27)) {
            return pgpSignatureSubpacketVector.getKeyFlags() == 0 && keyUsage == 0;
        }
        return false;
    }
}

