/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ega.egacryptor.pipeline;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.ega.egacryptor.constant.FileExtensionType;
import uk.ac.ebi.ega.egacryptor.cryptography.Cryptography;
import uk.ac.ebi.ega.egacryptor.cryptography.util.FileUtils;
import uk.ac.ebi.ega.egacryptor.cryptography.util.Hash;
import uk.ac.ebi.ega.egacryptor.exception.CryptographyException;
import uk.ac.ebi.ega.egacryptor.model.FileToProcess;
import uk.ac.ebi.ega.egacryptor.pipeline.CryptographyPipeline;
import uk.ac.ebi.ega.egacryptor.stream.pipeline.DefaultStream;

public class DefaultCryptographyPipeline
implements CryptographyPipeline {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCryptographyPipeline.class);
    private final int bufferSize;
    private final Cryptography cryptography;

    public DefaultCryptographyPipeline(Cryptography cryptography, int bufferSize) {
        this.cryptography = cryptography;
        this.bufferSize = bufferSize;
    }

    public void process(FileToProcess fileToProcess) {
        LOGGER.trace("Cryptography process is running");
        LOGGER.debug("filePathToEncrypt={}", (Object)fileToProcess);
        try {
            this.doProcess(fileToProcess);
        }
        catch (IOException | CryptographyException e) {
            LOGGER.error("Error while executing cryptography pipeline - {}", (Object)e.getMessage());
            throw new RuntimeException("Error while processing request", e);
        }
    }

    private void doProcess(FileToProcess fileToProcess) throws CryptographyException, IOException {
        long bytesRead;
        File inputFile = fileToProcess.getFileToEncryptPath().toFile();
        Path outputFilePath = fileToProcess.getOutputFilePath();
        File outputFile = outputFilePath.toFile();
        if (!outputFile.exists() && !outputFile.mkdirs()) {
            throw new FileNotFoundException("Path ".concat(outputFile.getPath()).concat(" doesn't exists. Unable to create path."));
        }
        File outputFileMD5 = FileUtils.newEmptyPath().resolve(outputFilePath).resolve(inputFile.getName().concat(FileExtensionType.MD5.getFileExtension())).toFile();
        File outputFileGPG = FileUtils.newEmptyPath().resolve(outputFilePath).resolve(inputFile.getName().concat(FileExtensionType.GPG.getFileExtension())).toFile();
        File outputFileGPGMD5 = FileUtils.newEmptyPath().resolve(outputFilePath).resolve(inputFile.getName().concat(FileExtensionType.GPG.getFileExtension().concat(FileExtensionType.MD5.getFileExtension()))).toFile();
        if (outputFileMD5.exists() || outputFileGPG.exists() || outputFileGPGMD5.exists()) {
            LOGGER.info("Process skip for file {}. All or some of these files are already exists - {},{},{}", new Object[]{inputFile.getPath(), outputFileMD5.getPath(), outputFileGPG.getPath(), outputFileGPGMD5.getPath()});
            return;
        }
        MessageDigest inputStreamMessageDigest = Hash.getMD5();
        MessageDigest outputStreamMessageDigest = Hash.getMD5();
        DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(inputFile), inputStreamMessageDigest);
        try (DigestOutputStream digestOutputStream = new DigestOutputStream(new FileOutputStream(outputFileGPG), outputStreamMessageDigest);){
            OutputStream pgpEncryptedOutputStream = this.cryptography.encrypt((OutputStream)digestOutputStream);
            try (DefaultStream pipelineStream = new DefaultStream((InputStream)digestInputStream, pgpEncryptedOutputStream, this.bufferSize);){
                LOGGER.info("File {} is being processed", (Object)inputFile.getPath());
                bytesRead = pipelineStream.execute();
            }
        }
        FileUtils.writeToFile((File)outputFileMD5, (String)Hash.normalize((MessageDigest)inputStreamMessageDigest));
        FileUtils.writeToFile((File)outputFileGPGMD5, (String)Hash.normalize((MessageDigest)outputStreamMessageDigest));
        LOGGER.info("File {} is successfully encrypted. Total bytes read {}. These files have been generated {},{},{}", new Object[]{inputFile.getPath(), bytesRead, outputFileMD5.getPath(), outputFileGPG.getPath(), outputFileGPGMD5.getPath()});
    }
}

