/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ega.egacryptor.runner;

import joptsimple.OptionParser;

public class CommandLineOptionParser {
    public static final String FILE_TO_ENCRYPT_PATH = "i";
    public static final String OUTPUT_FOLDER_PATH = "o";
    public static final String UTILIZE_FULL_RESOURCE = "f";
    public static final String UTILIZE_OPTIMIZE_RESOURCE = "m";
    public static final String UTILIZE_HALF_RESOURCE = "l";
    public static final String USER_THREADS = "t";
    public static final String OPTIONS_HELP = "h";
    private static final OptionParser optionParser = CommandLineOptionParser.buildParser();

    private static OptionParser buildParser() {
        OptionParser parser = new OptionParser();
        parser.accepts(FILE_TO_ENCRYPT_PATH, "File(s) to encrypt. Provide file/folder path or comma separated file path if multiple files in double quotes").withRequiredArg().required().ofType(String.class);
        parser.accepts(OUTPUT_FOLDER_PATH, "Path of the output file. This is optional. If not provided then output files will be generated in the same path as that of source file").withRequiredArg().ofType(String.class).defaultsTo((Object)"output-files", (Object[])new String[0]);
        parser.accepts(UTILIZE_FULL_RESOURCE, "Set this option to allow application to create maximum threads to utilize full capacity of cores/processors available on machine");
        parser.accepts(UTILIZE_OPTIMIZE_RESOURCE, "Set this option to allow application to create maximum threads equals to 75% capacity of cores/processors available on machine");
        parser.accepts(UTILIZE_HALF_RESOURCE, "Set this option to allow application to create maximum threads equals to 50% capacity of cores/processors available on machine");
        parser.accepts(USER_THREADS, "Set this option if user wants to control application to create maximum threads as specified. Application will calculate no. of cores/processors available on machine & will create threads accordingly").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPTIONS_HELP, "Use this option to get help");
        parser.allowsUnrecognizedOptions();
        return parser;
    }

    public static OptionParser getOptionParser() {
        return optionParser;
    }
}

