/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ega.egacryptor.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.OptionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CommandLineOptionProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLineOptionProcessor.class);
    private final List<Path> fileToEncryptPaths;
    private final Path outputFolderPath;
    private final int noOfThreads;

    private CommandLineOptionProcessor(OptionSet optionSet, Path defaultOutputFilePath) throws FileNotFoundException {
        String userDefinedOutputFilePath = optionSet.valueOf("o").toString();
        this.outputFolderPath = StringUtils.isEmpty((Object)userDefinedOutputFilePath) ? defaultOutputFilePath.normalize().toAbsolutePath() : Paths.get(userDefinedOutputFilePath, new String[0]).normalize().toAbsolutePath();
        File outputFolder = this.outputFolderPath.toFile();
        if (!outputFolder.exists() && !outputFolder.mkdirs()) {
            throw new FileNotFoundException("Output directory path doesn't exists. Unable to create directory.");
        }
        this.fileToEncryptPaths = Arrays.asList(optionSet.valueOf("i").toString().split(",")).parallelStream().map(filePath -> Paths.get(filePath.trim(), new String[0]).normalize().toAbsolutePath()).collect(Collectors.toList());
        this.noOfThreads = this.determineNoOfThreads(optionSet);
        LOGGER.info("Maximum {} no. of threads will be created to process the file(s)", (Object)this.noOfThreads);
    }

    static CommandLineOptionProcessor processOptions(OptionSet optionSet, Path defaultOutputFilePath) throws IOException {
        return new CommandLineOptionProcessor(optionSet, defaultOutputFilePath);
    }

    private int determineNoOfThreads(OptionSet optionSet) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        LOGGER.info("Application has detected {} no. of cores/processors. Threads will be created based on option provided", (Object)availableProcessors);
        if (availableProcessors == 1) {
            LOGGER.info("Single processor has been detected. File(s) will be processed sequentially. Any provided option will be ignored");
            return 1;
        }
        if (optionSet.has("l")) {
            LOGGER.info("Half resource option has been selected");
            return availableProcessors / 2;
        }
        if (optionSet.has("m")) {
            LOGGER.info("Optimized resource option has been selected");
            return (int)((float)availableProcessors * 0.75f);
        }
        if (optionSet.has("f")) {
            LOGGER.info("Full resource option has been selected");
            return availableProcessors - 1;
        }
        if (optionSet.has("t")) {
            LOGGER.info("User defined resource option has been selected");
            int userDefinedThreads = Integer.parseInt(optionSet.valueOf("t").toString());
            if (userDefinedThreads >= availableProcessors) {
                LOGGER.warn("Provided no. of threads are >= available cores on this machine. Application will try to use maximum resources to process the file(s)");
                return availableProcessors - 1;
            }
            if (userDefinedThreads <= 0) {
                LOGGER.warn("Provided no. of threads are <= 0. Application will process the file(s) sequentially using single thread");
                return 1;
            }
            return userDefinedThreads;
        }
        LOGGER.warn("No option has been provided. Application will process the file(s) sequentially using single thread");
        return 1;
    }

    public List<Path> getFileToEncryptPaths() {
        return this.fileToEncryptPaths;
    }

    public Path getOutputFolderPath() {
        return this.outputFolderPath;
    }

    public int getNoOfThreads() {
        return this.noOfThreads;
    }
}

