/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ega.egacryptor.runner;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import uk.ac.ebi.ega.egacryptor.cryptography.pgp.PGPCryptography;
import uk.ac.ebi.ega.egacryptor.runner.CommandLineOptionParser;
import uk.ac.ebi.ega.egacryptor.runner.CommandLineOptionProcessor;
import uk.ac.ebi.ega.egacryptor.runner.EgaCryptorCommandLinerRunner;
import uk.ac.ebi.ega.egacryptor.service.IFileDiscoveryService;
import uk.ac.ebi.ega.egacryptor.service.ITaskExecutorService;

public class EgaCryptorCommandLinerRunner
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPCryptography.class);
    private final ITaskExecutorService taskExecutorService;
    private final IFileDiscoveryService fileDiscoveryService;
    private final ApplicationContext applicationContext;
    private final Path defaultOutputFilePath;

    public EgaCryptorCommandLinerRunner(ITaskExecutorService taskExecutorService, IFileDiscoveryService fileDiscoveryService, ApplicationContext applicationContext, String defaultOutputFilePath) {
        this.taskExecutorService = taskExecutorService;
        this.fileDiscoveryService = fileDiscoveryService;
        this.applicationContext = applicationContext;
        this.defaultOutputFilePath = Paths.get(defaultOutputFilePath, new String[0]);
    }

    public void run(String ... args) throws IOException {
        OptionParser optionParser = CommandLineOptionParser.getOptionParser();
        try {
            OptionSet optionSet = optionParser.parse(args);
            if (optionSet.has("h")) {
                optionParser.printHelpOn((OutputStream)System.out);
                this.terminateApplication(() -> ((ApplicationStatus)ApplicationStatus.SUCCESS).getValue());
            }
            CommandLineOptionProcessor commandLineOptionProcessor = CommandLineOptionProcessor.processOptions((OptionSet)optionSet, (Path)this.defaultOutputFilePath);
            this.terminateApplication(() -> this.doRun(commandLineOptionProcessor));
        }
        catch (OptionException e) {
            LOGGER.error("Passed invalid command line arguments");
            optionParser.printHelpOn((OutputStream)System.out);
            this.terminateApplication(() -> ((ApplicationStatus)ApplicationStatus.INVALID_COMMANDLINE_ARGUMENTS).getValue());
        }
    }

    private int doRun(CommandLineOptionProcessor parser) {
        LOGGER.info("Process started at {} ---------------", (Object)new Date());
        try {
            List fileToProcessList = this.fileDiscoveryService.discoverFilesRecursively(parser.getFileToEncryptPaths(), parser.getOutputFolderPath());
            if (parser.getNoOfThreads() == 1) {
                this.taskExecutorService.execute(fileToProcessList);
            } else {
                this.taskExecutorService.execute(fileToProcessList, parser.getNoOfThreads());
            }
            LOGGER.info("Process completed at {} ---------------", (Object)new Date());
            return ApplicationStatus.SUCCESS.getValue();
        }
        catch (Exception e) {
            LOGGER.error("Error while running an application - ", (Throwable)e);
            return ApplicationStatus.APPLICATION_FAILED.getValue();
        }
    }

    private void terminateApplication(ExitCodeGenerator exitCodeGenerator) {
        System.exit(SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{exitCodeGenerator}));
    }
}

