/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ega.egacryptor.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.ega.egacryptor.constant.FileExtensionType;
import uk.ac.ebi.ega.egacryptor.model.FileToProcess;
import uk.ac.ebi.ega.egacryptor.service.IFileDiscoveryService;

public class FileDiscoveryService
implements IFileDiscoveryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDiscoveryService.class);

    public List<FileToProcess> discoverFilesRecursively(List<Path> rootFilePaths, Path outputFilePath) {
        LOGGER.trace("Executing file discovery service");
        ArrayList<FileToProcess> retrievedFilePaths = new ArrayList<FileToProcess>();
        rootFilePaths.stream().map(rootFilePath -> {
            try {
                return this.discoverFiles(rootFilePath, outputFilePath);
            }
            catch (IOException e) {
                LOGGER.error("Error in file discovery - {}", (Object)e.getMessage());
                return Collections.emptyList();
            }
        }).forEach(eachRetrievedFilePaths -> retrievedFilePaths.addAll((Collection<FileToProcess>)eachRetrievedFilePaths));
        return retrievedFilePaths;
    }

    private List<FileToProcess> discoverFiles(Path rootFilePath, Path outputFilePath) throws IOException {
        return Files.walk(rootFilePath, new FileVisitOption[0]).filter(path -> {
            try {
                LOGGER.debug("FilePath {}", path);
                if (Files.isRegularFile(path, new LinkOption[0]) && !Files.isHidden(path) && !Files.isDirectory(path, new LinkOption[0]) && !FileExtensionType.containsFileExtension((String)path.toString())) {
                    String originalFilePath = path.toString();
                    File md5File = new File(originalFilePath.concat(FileExtensionType.MD5.getFileExtension()));
                    File gpgFile = new File(originalFilePath.concat(FileExtensionType.GPG.getFileExtension()));
                    File gpgMd5File = new File(originalFilePath.concat(FileExtensionType.GPG.getFileExtension().concat(FileExtensionType.MD5.getFileExtension())));
                    if (gpgFile.exists() || md5File.exists() || gpgMd5File.exists()) {
                        LOGGER.info("Process skip for file {}. All or some of these files are already exists - {},{},{}", new Object[]{originalFilePath, md5File.getPath(), gpgFile.getPath(), gpgMd5File.getPath()});
                        return false;
                    }
                    return true;
                }
            }
            catch (IOException e) {
                LOGGER.error("Invalid file {}. - {}", (Object)path.toString(), (Object)e.getMessage());
            }
            return false;
        }).map(validFilePath -> this.calculateOutputPath(rootFilePath, validFilePath, outputFilePath)).collect(Collectors.toList());
    }

    private FileToProcess calculateOutputPath(Path rootFilePath, Path subFilePath, Path outputFilePath) {
        Path subPathMinusRootPath;
        if (outputFilePath.toString().isEmpty()) {
            return new FileToProcess(subFilePath);
        }
        if (!subFilePath.equals(rootFilePath) && (subPathMinusRootPath = subFilePath.subpath(rootFilePath.getNameCount(), subFilePath.getNameCount())).getParent() != null) {
            Path newOutputFilePath = outputFilePath.resolve(subPathMinusRootPath.getParent());
            return new FileToProcess(subFilePath, newOutputFilePath);
        }
        return new FileToProcess(subFilePath, outputFilePath);
    }
}

