/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ega.egacryptor.service;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.ega.egacryptor.model.FileToProcess;
import uk.ac.ebi.ega.egacryptor.pipeline.CryptographyPipeline;
import uk.ac.ebi.ega.egacryptor.service.FileDiscoveryService;
import uk.ac.ebi.ega.egacryptor.service.ITaskExecutorService;

public class TaskExecutorService
implements ITaskExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDiscoveryService.class);
    private final CryptographyPipeline cryptographyPipeline;

    public TaskExecutorService(CryptographyPipeline cryptographyPipeline) {
        this.cryptographyPipeline = cryptographyPipeline;
    }

    public void execute(List<FileToProcess> fileToProcessList) {
        LOGGER.trace("Sequential task executor is running");
        LOGGER.debug("File to process list size={}", (Object)fileToProcessList.size());
        fileToProcessList.forEach(arg_0 -> ((CryptographyPipeline)this.cryptographyPipeline).process(arg_0));
    }

    public void execute(List<FileToProcess> fileToProcessList, int noOfThreads) {
        LOGGER.trace("Parallel task executor is running");
        LOGGER.debug("File to process list size={}, No of threads={}", (Object)fileToProcessList.size(), (Object)noOfThreads);
        int noOfThreadsToCreate = Math.min(fileToProcessList.size(), noOfThreads);
        LOGGER.info("Based on file count, {} no. of threads will process the file(s)", (Object)noOfThreads);
        ExecutorService executor = Executors.newFixedThreadPool(noOfThreadsToCreate);
        List futureList = fileToProcessList.stream().map(fileToProcess -> executor.submit(() -> this.cryptographyPipeline.process(fileToProcess), fileToProcess.getFileToEncryptPath().toString())).collect(Collectors.toList());
        for (Future stringFuture : futureList) {
            try {
                stringFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Error while iterating over future list - " + e.getMessage(), (Throwable)e);
            }
        }
        executor.shutdownNow();
    }
}

