/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ega.egacryptor.stream.pipeline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.util.Arrays;
import uk.ac.ebi.ega.egacryptor.stream.pipeline.PipelineStream;

public class DefaultStream
implements PipelineStream {
    private final InputStream sourceInputStream;
    private final OutputStream targetOutputStream;
    private final int bufferSize;

    public DefaultStream(InputStream sourceInputStream, OutputStream targetOutputStream, int bufferSize) {
        this.sourceInputStream = sourceInputStream;
        this.targetOutputStream = targetOutputStream;
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execute() throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        try {
            int bytesRead;
            long totalRead = 0L;
            while ((bytesRead = this.sourceInputStream.read(buffer)) > 0) {
                totalRead += (long)bytesRead;
                this.targetOutputStream.write(buffer, 0, bytesRead);
            }
            this.targetOutputStream.flush();
            long l = totalRead;
            return l;
        }
        finally {
            Arrays.fill((byte[])buffer, (byte)0);
        }
    }

    public void close() throws IOException {
        this.sourceInputStream.close();
        this.targetOutputStream.close();
    }
}

